using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This class represents exceptions that occur when VistALink RPC 
	/// fault messages are received. When this exception is thrown it indicates
	/// that something was wrong with the RPC called. However, it doesn't indicate
	/// listener problems and, in general, more RPC calls may be made if this exception is 
	/// handled properly. 
	/// </summary>
	public class RpcFaultException : VistALinkFaultException
	{
		/// <summary>
		/// This constructor accepts fault info object containing 
		/// information about a fault occured at server side.
		/// </summary>
		/// <param name="faultInfo">
		///		Fault info object containing information about a fault
		///		occured at server side.
		///	</param>
		public RpcFaultException( FaultInfo faultInfo)
			: base( faultInfo ) {}
	}
}
